function profile=read_Profile(fid)

C=textscan(fid,'%s %s',1);
profile.orig_filename=C{1,2};
C=textscan(fid,'%s %s %s',1);
profile.campaign=C{1,3};
C=textscan(fid,'%s %s %d',1);
profile.campaign_number=C{1,3};
C=textscan(fid,'%s %s %s %d',1);
profile.number_of_rays=C{1,4};
C=textscan(fid,'%s %s %s',1);
profile.start_time=datenum((C{1,3}),'HH:MM:SS');
C=textscan(fid,'%s %s %s %s %s %s %s %s %s',1);
maxs=5000*profile.number_of_rays
C=textscan(fid,'%d %n %n %s %n %n %n %n',maxs);
ntot=length(C{1,1});
h=C{1,1};
rws=C{1,2};
snr=C{1,3};
time=C{1,4};
az=C{1,5};
el=C{1,6};
pitch=C{1,7};
roll=C{1,8};
nr=ntot/profile.number_of_rays;
profile.heights=h(1:nr);
profile.pitch=pitch(1);
profile.roll=roll(1);
kk=1
for j=1:profile.number_of_rays
    profile.azimuth(j)=az(kk);
    profile.elevation(j)=el(kk);
    for k=1:nr
        profile.RWS(j,k)=rws(kk);
        profile.SNR(j,k)=snr(kk);
        oops=datevec(time(kk));
        profile.lidar_decimal_time(j)=oops(4)+(oops(5)+(oops(6)/60))/60;
        kk=kk+1;
    end
end
return









